unit Cbtests2;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, CB_Gdi, CB3Party;

type
  TCBGraphicControlTest = class(TCBGraphicControl)
  private
  		FBrush: TBrush;
  protected
      constructor Create(AOwner: TComponent); override;
      destructor  Destroy; override;
		procedure   Paint; override;
  public
		procedure PrintWindow( var CBPrint: TCBPrint ); override;
  published
  		property Brush: TBrush   read   FBrush   write  FBrush;
      property Font;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('CBSuite', [TCBGraphicControlTest]);
end;

constructor TCBGraphicControlTest.Create(AOwner: TComponent);
begin
   inherited Create(AOwner);
   FBrush := TBrush.Create;
end;

destructor  TCBGraphicControlTest.Destroy;
begin
	FBrush.Free;
   inherited Destroy;
end;


procedure TCBGraphicControlTest.Paint;
begin
 	inherited Paint;
   Canvas.Brush.Assign(FBrush);
   Canvas.Font.Assign(Font);
   Canvas.Rectangle( 0,0,Width,Height);
   Canvas.MoveTo(0,0);
   Canvas.LineTo(Width,Height);
   Canvas.MoveTo(Width,0);
   Canvas.LineTo(0,Height);
   Canvas.TextOut (2, Height div 2 , 'Hi there, My Parent is a TCBGraphicControl');


end;


procedure TCBGraphicControlTest.PrintWindow( var CBPrint: TCBPrint );
var
	Point: TPoint;
begin
   Point.X := CBPrint.Point.x;
   Point.y := CBPrint.Point.y;

   with CBPrint.Gdi do begin
   	SetFinalFont (Font);
   	SetBrushPrivate(FBrush);
   	DFillRect( Rect(0,0,Width,Height), CBPrint.Point);
   	DDrawRectangle( 0,0,Width,Height, CBPrint.Point);
   	DDrawLine(0,0,Width,Height,CBPrint.Point);
   	DDrawLine(Width,0,0,Height,CBPrint.Point);
   	DDrawTheText (2, Height div 2 , 'Hi there, My Parent is a TCBGraphicControl', CBPrint.Point);
	end;
end;


end.
